function symbols = QAM_modulation(data_input,n,Eb)
map = QAM_mapping(n);

A=sqrt(Eb);
B=A*sqrt(0.4);
C=A*sqrt(1/7);

% QAM modulation
if n == 4
    for ii=1:(length(data_input)/2)
        x = data_input(2*ii-1)*10+data_input(2*ii);
        if x == 0;                    % find() can only deal with positive value
            symbols(ii) = complex(A,A);
        else
        [y,z] = find(map==x);
        symbols(ii) = (z-1.5)*2*A+j*(1.5-y)*2*A; % creat the relationship between matlab_array and
        end                           % QAM_coordinates. Can be seen as the translation
    end                               % of the coordinates central.
end

if n == 16
    for ii = 1:(length(data_input)/4)
        x = data_input(4*ii-3)*1000+data_input(4*ii-2)*100+data_input(4*ii-1)*10+data_input(4*ii);
        if x == 0;
            symbols(ii) = complex(3*B,3*B);
        else
            [y,z] = find(map==x);
            symbols(ii) = (z-2.5)*2*B+1i*(2.5-y)*2*B;
        end
    end
end

if n == 64
    for ii = 1:(length(data_input)/6)
        x = data_input(6*ii-5)*100000+data_input(6*ii-4)*10000+data_input(6*ii-3)*1000+data_input(6*ii-2)*100+data_input(6*ii-1)*10+data_input(6*ii);
        if x == 0;
            symbols(ii) = complex(7*C,7*C);
        else
            [y,z] = find(map==x);
            symbols(ii) = (z-4.5)*2*C+1i*(4.5-y)*2*C;
        end
    end
end

end

